/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs;

import com.ibm.hwmca.base.custinfo.CustomerInfoData;
import com.ibm.hwmca.base.custinfo.CustomerInfoEvent;
import com.ibm.hwmca.base.custinfo.CustomerInfoListener;
import com.ibm.hwmca.base.custinfo.CustomerInfoManager;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.rcs.RcsControl;
import com.ibm.hwmca.fw.rcs.conndata.ConnectionInfoManager;
import com.ibm.hwmca.fw.rcs.conndata.ConnectivityInfo;
import com.ibm.hwmca.fw.rcs.conndata.PhoneInfo;
import com.ibm.hwmca.fw.rcs.conndata.ServerInfo;
import com.ibm.hwmca.fw.rcs.inconn.InboundConfigData;
import com.ibm.hwmca.fw.rcs.inconn.InboundConfigEvent;
import com.ibm.hwmca.fw.rcs.inconn.InboundConfigListener;
import com.ibm.hwmca.fw.rcs.inconn.InboundConfigManager;
import com.ibm.hwmca.fw.rcs.modemcfg.ModemConfigData;
import com.ibm.hwmca.fw.rcs.modemcfg.ModemConfigEvent;
import com.ibm.hwmca.fw.rcs.modemcfg.ModemConfigListener;
import com.ibm.hwmca.fw.rcs.modemcfg.ModemConfigManager;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigData;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigEvent;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigListener;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigManager;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class RcsConfig
implements OutboundConfigListener,
InboundConfigListener,
ModemConfigListener,
CustomerInfoListener {
    private static final String TRACE_MASKT = "XRCSCFGT";
    private static final String TRACE_MASKF = "XRCSCFGF";
    private static final String TRACE_MASKD = "XRCSCFGD";
    private static final String CONFIG_HEADER = "IBM HMC RCS Control Config File";
    private static final String CONFIG_FILE = "rcsTempConfig.props";
    private static final String OVERRIDE_FILE = "rcsOverride.props";
    public static RcsConfig instance = null;
    private static final String vpnAuthPsk = "TStoIBMVPNGW";
    private static final String l2tpAuthUser = "IBMServiceHMC@iecare1.ibm.com";
    private static final String l2tpAuthPw = "72b6a8db04545f0d5cb4f7c2f55a64";
    private static final String attAuthPw = "notused";
    private String configPath;
    private String runAsRootPath;
    private Properties overrideProps;
    private Map tempConfig;
    private Map baseConfig;
    private Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RcsConfig() {
        Trace.trace(TRACE_MASKT, "--> RcsConfig");
        try {
            Object object = this.lock;
            synchronized (object) {
                this.configPath = BaseFileControl.getFilePath("rcsconfig");
                this.runAsRootPath = BaseFileControl.getFilePath("runAsRoot");
                this.baseConfig = new HashMap();
                this.tempConfig = new HashMap();
                this.overrideProps = new Properties();
                OutboundConfigManager.getOutboundConfigManager().addOutboundConfigListener(this);
                InboundConfigManager.getInboundConfigManager().addInboundConfigListener(this);
                ModemConfigManager.getModemConfigManager().addModemConfigListener(this);
                CustomerInfoManager.getCustomerInfoManager().addCustomerInfoListener(this);
                this.initConfig();
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception: " + e);
        }
        Trace.trace(TRACE_MASKT, "<-- RcsConfig");
    }

    public static RcsConfig getRcsConfig() {
        Trace.trace(TRACE_MASKT, "<-> getRcsConfig()");
        if (instance == null) {
            instance = new RcsConfig();
            return instance;
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConfig() {
        Trace.trace(TRACE_MASKT, "--> initConfig()");
        ModemConfigData modemData = ModemConfigManager.getModemConfigManager().getModemConfig();
        OutboundConfigData outData = OutboundConfigManager.getOutboundConfigManager().getOutboundConfig();
        InboundConfigData inData = InboundConfigManager.getInboundConfigManager().getInboundConfig();
        CustomerInfoData custData = CustomerInfoManager.getCustomerInfoManager().getCustomerInfo();
        Object object = this.lock;
        synchronized (object) {
            this.baseConfig = new HashMap();
            String country = custData.getSystemCountryCode();
            String region = custData.getSystemSubdivisionCode();
            ConnectivityInfo connData = ConnectionInfoManager.getConnectionInfoManager().getConnectivityInfo(country, region);
            String dialPrefix = modemData.getDialPrefix();
            List phoneInfo = outData.getPhoneInfo();
            Iterator pi = phoneInfo.iterator();
            String attPrimaryNumber = pi.hasNext() ? dialPrefix + ((PhoneInfo)pi.next()).getDialString() : "";
            String attBackupNumber = pi.hasNext() ? dialPrefix + ((PhoneInfo)pi.next()).getDialString() : "";
            boolean incomingCalls = inData.isAllowCallAnswer();
            boolean outgoingCalls = outData.isCallHomeServer() && outData.isAllowDial() && !attPrimaryNumber.equals("");
            ServerInfo serverInfo = connData.getServerInfo("Server_VPN");
            String vpnServer = serverInfo == null ? "" : serverInfo.getIpAddress();
            serverInfo = connData.getServerInfo("Server_RS3");
            String rs3Server = serverInfo == null ? "" : serverInfo.getIpAddress();
            String rs3Port = serverInfo == null ? "" : String.valueOf(serverInfo.getPort());
            serverInfo = connData.getServerInfo("Server_SA");
            String sdrServer = serverInfo == null ? "" : serverInfo.getIpAddress();
            serverInfo = connData.getServerInfo("Server_SAS");
            String sasServer = serverInfo == null ? "" : serverInfo.getIpAddress();
            serverInfo = connData.getServerInfo("Server_URSF");
            String ursfServer = serverInfo == null ? "" : serverInfo.getIpAddress();
            this.baseConfig.put("loc_country", country);
            this.baseConfig.put("loc_region", region);
            this.baseConfig.put("vpn_server", vpnServer);
            this.baseConfig.put("vpn_auth_psk", vpnAuthPsk);
            this.baseConfig.put("l2tp_outgoing_calls", outgoingCalls ? "1" : "0");
            this.baseConfig.put("l2tp_incoming_calls", incomingCalls ? "1" : "0");
            this.baseConfig.put("l2tp_remote_host", "127.0.0.1");
            this.baseConfig.put("l2tp_auth_user", l2tpAuthUser);
            this.baseConfig.put("l2tp_auth_pw", l2tpAuthPw);
            this.baseConfig.put("host_rs3", rs3Server);
            this.baseConfig.put("host_sdr", sdrServer);
            this.baseConfig.put("host_sas", sasServer);
            this.baseConfig.put("host_ursf", ursfServer);
            this.baseConfig.put("port_rs3", rs3Port);
            this.baseConfig.put("modem_init", modemData.getInitString());
            this.baseConfig.put("modem_post_init", modemData.getPostInitString());
            this.baseConfig.put("modem_answer_init", modemData.getAnswerInitString());
            this.baseConfig.put("modem_dial_mode", modemData.getDialModeString());
            this.baseConfig.put("att_number_primary", attPrimaryNumber);
            this.baseConfig.put("att_number_backup", attBackupNumber);
            this.baseConfig.put("att_auth_pw", attAuthPw);
            this.baseConfig.put("run_as_root", this.runAsRootPath);
        }
        Trace.trace(TRACE_MASKT, "<-- initConfig()");
    }

    private void loadOverrideFile() {
        Trace.trace(TRACE_MASKT, "--> loadOverrideFile()");
        try {
            this.overrideProps = new Properties();
            this.overrideProps.load(new FileInputStream(new File(this.configPath, OVERRIDE_FILE)));
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "Failed to load override file: " + e);
        }
        Trace.trace(TRACE_MASKT, "<-- loadOverrideFile()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeConfig() throws IOException {
        Trace.trace(TRACE_MASKT, "--> storeConfig()");
        Object object = this.lock;
        synchronized (object) {
            String key;
            this.loadOverrideFile();
            Properties configProps = new Properties();
            Iterator<Object> i = this.baseConfig.keySet().iterator();
            while (i.hasNext()) {
                key = (String)i.next();
                configProps.put(key, this.baseConfig.get(key));
            }
            i = this.tempConfig.keySet().iterator();
            while (i.hasNext()) {
                key = (String)i.next();
                configProps.put(key, this.tempConfig.get(key));
            }
            i = this.overrideProps.keySet().iterator();
            while (i.hasNext()) {
                key = (String)i.next();
                configProps.put(key, this.overrideProps.get(key));
            }
            FileOutputStream tempFile = new FileOutputStream(new File(this.configPath, CONFIG_FILE));
            configProps.store(tempFile, CONFIG_HEADER);
            tempFile.close();
        }
        Trace.trace(TRACE_MASKT, "<-- storeConfig()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTemporaryConfigValue(String key, String value) {
        Trace.trace(TRACE_MASKT, "<-> setTemporaryConfigValue( " + key + ", " + value + " )");
        Object object = this.lock;
        synchronized (object) {
            this.tempConfig.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConfigValue(String key) {
        Trace.trace(TRACE_MASKT, "--> getConfigValue( " + key + " )");
        String value = null;
        Object object = this.lock;
        synchronized (object) {
            this.loadOverrideFile();
            value = this.tempConfig.containsKey(key) ? (String)this.tempConfig.get(key) : (this.overrideProps.containsKey(key) ? (String)this.baseConfig.get(key) : (String)this.overrideProps.get(key));
        }
        Trace.trace(TRACE_MASKT, "<-- getConfigValue() [" + value + "]");
        return value;
    }

    public void outboundConfigChanged(OutboundConfigEvent event) {
        Trace.trace(TRACE_MASKT, "<-> outboundConfigChanged(" + event + ")");
        if (event.getEventType() == 1) {
            this.initConfig();
            this.spawnForceUpdate();
        }
    }

    public void inboundConfigChanged(InboundConfigEvent event) {
        Trace.trace(TRACE_MASKT, "<-> inboundConfigChanged(" + event + ")");
        if (event.getEventType() == 1) {
            this.initConfig();
            this.spawnForceUpdate();
        }
    }

    public void modemConfigChanged(ModemConfigEvent event) {
        Trace.trace(TRACE_MASKT, "<-> modemConfigChanged(" + event + ")");
        if (event.getEventType() == 1) {
            this.initConfig();
            this.spawnForceUpdate();
        }
    }

    public void customerInfoChanged(CustomerInfoEvent event) {
        Trace.trace(TRACE_MASKT, "<-> customerConfigChanged(" + event + ")");
        if (event.getEventType() == 1) {
            this.initConfig();
            this.spawnForceUpdate();
        }
    }

    private void spawnForceUpdate() {
        new Thread("RcsControl.forceUpdate()"){

            public void run() {
                RcsControl.forceUpdate();
            }
        }.start();
    }
}

